#import data frame
required_packages <- c("readxl")
# Install and load packages if not already installed
for (package in required_packages) {
  if (!requireNamespace(package, quietly = TRUE)) {
    install.packages(package)
  }
  library(package, character.only = TRUE)
}

file_path <- "/cohort.xlsx" #your path of the cohort file
df <- read_excel(file_path, sheet = "cohort", na = "#N/A")

#3. Results
#3.1. Patient characteristics
source("3.1_Patient_characteristics.R", local = TRUE)
#text output
#saving Table 1. Patient, tumor, PET/CT, and treatment characteristics

#3.2. Association of biological variables and semiquantitative PET parameters
#3.2.1 SUV
source("3.2.1_SUV.R", local = TRUE)
#text output

#3.2.2 PET scanner
source("3.2.2_scanner.R", local = TRUE)
#saving Table A1. Comparing SUV measurements regarding PET-CT scanner
#text output

#3.2.3a Characteristics of all patients
source("3.2.3a_characteristics.R", local = TRUE)
#saving Table 2. Influence of patient characteristics on metabolic activity of lung tissue.
#Table 2 combines table s1a overview, table s1b correlation and table s1c estimate in one table
#Supplementary Materials s1: table 2a overview, table 2b correlation and table 2c estimate
#text output

#3.2.3b Characteristics of subgroup (patients scanned with GE Discovery 690)
source("3.2.3b_characteristics_subgroup.R", local = TRUE)
#saving Table A2. Influence of patient characteristics on metabolic activity of lung tissue for patients scanned with GE Discovery 690 
#Table A2 combines table s2a overview, table s2b correlation and table s2c estimate in one table
#Supplementary Materials s2: table A2a overview, table A2b correlation and table A2c estimate

#3.2.4 Correlation of BMI and COPD on SUV
source("3.2.4_correlation_bmi_copd.R", local = TRUE)
#saving Fig. 2 (a) boxplot copd ; (b) scatterplot bmi

#3.2.5a Multilinear regression
source("3.2.5a_multilinear_regression.R", local = TRUE)
#saving Fig. 3 Forest plot of multilinear regression with SUV as response and biological variables as independent variables
#text output

#3.2.5b Multilinear regression of subgroup (patients scanned with GE Discovery 690)
source("3.2.5b_multilinear_regression_subgroup.R", local = TRUE)
#Supplementary Materials s3: Fig. S3 Forest plot of subgroup (patients scanned with GE Discovery 690)
